/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.util.LogoComfortStatusLine;
import DE.siemens.ad.udf.EditUDFFigure;
import DE.siemens.ad.udf.LogoDrawingUDF;
import java.awt.Color;

public class InsertConnectionAction
extends UndoableAction {
    protected ConnectionFigure connectionFigure;
    protected boolean generateMiniBlockFigure = false;

    public InsertConnectionAction() {
        this.putValue("ShortDescription", Language.getStringNoTilde("pdraw.standard.creation", "Creation"));
    }

    public boolean doIt() {
        LogoDrawing drawing = (LogoDrawing)((LogoComfort)this.getOwner()).view().drawing();
        if (this.generateMiniBlockFigure && drawing instanceof LogoDrawingUDF) {
            EditUDFFigure editUDFFigure = ((LogoDrawingUDF)drawing).getEditUDFFigure();
            if (this.connectionFigure.start().owner().container() instanceof EditUDFFigure.MiniBlockFigure && !editUDFFigure.getInputfigures().contains(this.connectionFigure.start().owner().container()) && !editUDFFigure.getOutputfigures().contains(this.connectionFigure.start().owner().container())) {
                ((EditUDFFigure.MiniBlockFigure)this.connectionFigure.start().owner().container()).getConstraint().insert(drawing);
            } else if (this.connectionFigure.end().owner().container() instanceof EditUDFFigure.MiniBlockFigure && !editUDFFigure.getInputfigures().contains(this.connectionFigure.end().owner().container()) && !editUDFFigure.getOutputfigures().contains(this.connectionFigure.end().owner().container())) {
                ((EditUDFFigure.MiniBlockFigure)this.connectionFigure.end().owner().container()).getConstraint().insert(drawing);
            }
        }
        this.connectionFigure.getConstraint().insert(drawing);
        this.connectionFigure.updateConnection();
        LogoComfort logoComfort = (LogoComfort)this.getOwner();
        WiringDiagram wd = ((LogoDrawing)logoComfort.drawing()).getWiringDiagram();
        if (!wd.isStackDepthOk()) {
            this.connectionFigure.getConstraint().delete();
            LogoComfortStatusLine statusLine = (LogoComfortStatusLine)logoComfort.getStatusLine();
            statusLine.setTemporaryMessage(Language.getString("msg.stackdepth", "Stackdepth to large for selected hardware"), 5000, Color.red);
            return false;
        }
        super.doIt();
        if (!wd.isCorrect()) {
            this.connectionFigure.getConstraint().delete();
            LogoComfortStatusLine statusLine = (LogoComfortStatusLine)logoComfort.getStatusLine();
            statusLine.setTemporaryMessage(Language.getString("msg.tooManyBlocks", "The maximum number of blocks is reached"), 5000, Color.red);
            return false;
        }
        return true;
    }

    public void setConnectionFigure(ConnectionFigure newConnectionFigure) {
        this.connectionFigure = newConnectionFigure;
    }

    public boolean isGenerateMiniBlockFigure() {
        return this.generateMiniBlockFigure;
    }

    public void setGenerateMiniBlockFigure(boolean generateMiniBlockFigure) {
        this.generateMiniBlockFigure = generateMiniBlockFigure;
    }

    public String toString() {
        return super.toString() + ": " + this.connectionFigure;
    }

    public void undoIt() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        view.clearSelection();
        this.connectionFigure.getConstraint().delete();
        view.checkDamage();
        if (this.generateMiniBlockFigure) {
            if (this.connectionFigure.start().owner().container() instanceof EditUDFFigure.MiniBlockFigure) {
                ((EditUDFFigure.MiniBlockFigure)this.connectionFigure.start().owner().container()).getConstraint().delete();
            } else if (this.connectionFigure.end().owner().container() instanceof EditUDFFigure.MiniBlockFigure) {
                ((EditUDFFigure.MiniBlockFigure)this.connectionFigure.end().owner().container()).getConstraint().delete();
            }
        }
    }
}

